<?php
// api/CallinoApi.php
//
// توجه: این فقط اسکلت ارتباط است.
// باید طبق مستندات واقعی @CallinooapiBot
// آدرس endpoint ها و پارامترهای دقیق را تنظیم کنید.

class CallinoApi {
    private $apiKey;
    private $base;

    public function __construct() {
        $this->apiKey = CALLINO_API_KEY;
        $this->base   = rtrim(CALLINO_API_BASE, '/');
    }

    private function request($endpoint, $params = []) {
        $params['api_key'] = $this->apiKey;

        $ch = curl_init($this->base . $endpoint);
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST           => true,
            CURLOPT_POSTFIELDS     => http_build_query($params),
        ]);
        $res = curl_exec($ch);
        if ($res === false) {
            log_error('Callino curl error: ' . curl_error($ch));
            curl_close($ch);
            return false;
        }
        curl_close($ch);
        $data = json_decode($res, true);
        if (!is_array($data)) {
            log_error('Callino bad response: ' . $res);
        }
        return $data;
    }

    // سفارش پریمیوم
    public function orderPremium($telegramUserId, $serviceCode, $target) {
        // TODO: مسیر و پارامترها را با مستندات کالینو هماهنگ کن
        return $this->request('/premium/order', [
            'tg_id'  => $telegramUserId,
            'plan'   => $serviceCode,
            'user'   => $target,
        ]);
    }

    // سفارش استارز
    public function orderStars($telegramUserId, $serviceCode, $quantity, $target) {
        return $this->request('/stars/order', [
            'tg_id'    => $telegramUserId,
            'service'  => $serviceCode,
            'amount'   => $quantity,
            'user'     => $target,
        ]);
    }

    // سفارش شماره مجازی
    public function orderNumber($serviceCode, $countryCode) {
        return $this->request('/number/order', [
            'service' => $serviceCode,
            'country' => $countryCode,
        ]);
    }

    // گرفتن وضعیت سفارش
    public function getOrderStatus($orderId) {
        return $this->request('/order/status', [
            'order_id' => $orderId,
        ]);
    }
}
