<?php
// bootstrap.php - آماده‌سازی مشترک

require __DIR__ . '/config.php';
require __DIR__ . '/classes/Telegram.php';
require __DIR__ . '/classes/Keyboard.php';
require __DIR__ . '/api/CallinoApi.php';

try {
    $pdo = new PDO("mysql:host=".DB_HOST.";dbname=".DB_NAME.";charset=utf8mb4", DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (Throwable $e) {
    log_error('DB error: ' . $e->getMessage());
    exit('DB error');
}

$telegram = new Telegram(BOT_TOKEN);
$callino  = new CallinoApi();

// ------------- توابع عمومی -------------

function getUser(PDO $pdo, array $from) {
    $tgId = $from['id'];
    $stmt = $pdo->prepare("SELECT * FROM users WHERE tg_id = ?");
    $stmt->execute([$tgId]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($user) return $user;

    $stmt = $pdo->prepare("INSERT INTO users (tg_id, first_name, username) VALUES (?,?,?)");
    $stmt->execute([
        $tgId,
        $from['first_name'] ?? '',
        $from['username'] ?? ''
    ]);
    $stmt = $pdo->prepare("SELECT * FROM users WHERE tg_id = ?");
    $stmt->execute([$tgId]);
    return $stmt->fetch(PDO::FETCH_ASSOC);
}

function isAdmin(PDO $pdo, $tgId) {
    if ($tgId == OWNER_ID) return true;
    $stmt = $pdo->prepare("SELECT 1 FROM admins WHERE tg_id = ?");
    $stmt->execute([$tgId]);
    return (bool)$stmt->fetchColumn();
}

function setState(PDO $pdo, $userId, $state, $data = null) {
    $json = $data ? json_encode($data, JSON_UNESCAPED_UNICODE) : null;
    $stmt = $pdo->prepare("
        INSERT INTO states (user_id, state, data)
        VALUES (:user_id, :state, :data)
        ON DUPLICATE KEY UPDATE state = :state2, data = :data2
    ");
    $stmt->execute([
        ':user_id' => $userId,
        ':state'   => $state,
        ':data'    => $json,
        ':state2'  => $state,
        ':data2'   => $json,
    ]);
}

function getState(PDO $pdo, $userId) {
    $stmt = $pdo->prepare("SELECT state, data FROM states WHERE user_id = ?");
    $stmt->execute([$userId]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    if (!$row) return [null, null];
    return [$row['state'], $row['data'] ? json_decode($row['data'], true) : null];
}

function clearState(PDO $pdo, $userId) {
    $stmt = $pdo->prepare("DELETE FROM states WHERE user_id = ?");
    $stmt->execute([$userId]);
}
