<?php
// classes/Keyboard.php

class Keyboard {

    // منوی اصلی کاربر
    public static function userMain() {
        return [
            'keyboard' => [
                [['text' => '🎫 خرید پریمیوم'], ['text' => '⭐ خرید استارز']],
                [['text' => '📱 شماره مجازی'], ['text' => '💼 پروفایل من']],
                [['text' => '📜 سفارشات من'], ['text' => 'ℹ️ راهنما / پشتیبانی']],
            ],
            'resize_keyboard' => true
        ];
    }

    // منوی اصلی ادمین (داخل تلگرام)
    public static function adminMain() {
        return [
            'keyboard' => [
                [['text' => 'آمار ربات 📊']],
                [['text' => 'شارژ همگانی 💰'], ['text' => 'ارسال همگانی ✉️']],
                [['text' => 'مدیریت کاربران 👥'], ['text' => 'جستجو کاربر 🔍']],
                [['text' => 'مدیریت سفارشات 🛒'], ['text' => 'جستجو سفارش 📄']],
                [['text' => 'مدیریت خدمات 📝']],
                [['text' => 'مدیریت استارز ✨'], ['text' => 'مدیریت شماره مجازی 📱']],
                [['text' => 'مدیریت پریمیوم 💎'], ['text' => 'مدیریت گیفت 🎁']],
                [['text' => 'تنظیمات پرداخت 💳'], ['text' => 'مدیریت دکمه‌ها ⬛']],
                [['text' => 'تنظیمات وب‌سرویس 🌐'], ['text' => 'مدیریت کارمندان ⌨️']],
                [['text' => 'بازگشت به منوی کاربر ⬅️']],
            ],
            'resize_keyboard' => true
        ];
    }

    // کیبورد انتخاب نوع سرویس (در صورت نیاز)
    public static function buyTypesInline() {
        return [
            'inline_keyboard' => [
                [
                    ['text' => '⭐ استارز', 'callback_data' => 'buy_type:stars'],
                    ['text' => '🎫 پریمیوم', 'callback_data' => 'buy_type:premium'],
                ],
                [
                    ['text' => '📱 شماره مجازی', 'callback_data' => 'buy_type:number'],
                ]
            ]
        ];
    }
}
