<?php
// classes/Telegram.php

class Telegram {
    private $apiUrl;

    public function __construct($token) {
        $this->apiUrl = "https://api.telegram.org/bot{$token}/";
    }

    public function request($method, $params = []) {
        $ch = curl_init($this->apiUrl . $method);
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST           => true,
            CURLOPT_POSTFIELDS     => $params,
        ]);
        $res = curl_exec($ch);
        if ($res === false) {
            log_error('curl error: ' . curl_error($ch));
        }
        curl_close($ch);
        return json_decode($res, true);
    }

    public function sendMessage($chatId, $text, $replyMarkup = null, $parseMode = 'HTML') {
        $data = [
            'chat_id'    => $chatId,
            'text'       => $text,
            'parse_mode' => $parseMode,
        ];
        if ($replyMarkup) {
            $data['reply_markup'] = json_encode($replyMarkup);
        }
        return $this->request('sendMessage', $data);
    }

    public function editMessageText($chatId, $messageId, $text, $replyMarkup = null, $parseMode = 'HTML') {
        $data = [
            'chat_id'    => $chatId,
            'message_id' => $messageId,
            'text'       => $text,
            'parse_mode' => $parseMode,
        ];
        if ($replyMarkup) {
            $data['reply_markup'] = json_encode($replyMarkup);
        }
        return $this->request('editMessageText', $data);
    }

    public function answerCallbackQuery($id, $text = '', $showAlert = false) {
        return $this->request('answerCallbackQuery', [
            'callback_query_id' => $id,
            'text'              => $text,
            'show_alert'        => $showAlert ? 'true' : 'false',
        ]);
    }
}
