-- sql/schema.sql - ساخت جدول‌های مورد نیاز

CREATE TABLE IF NOT EXISTS users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    tg_id BIGINT NOT NULL UNIQUE,
    first_name VARCHAR(255),
    username VARCHAR(64),
    lang ENUM('fa','en') DEFAULT 'fa',
    balance BIGINT DEFAULT 0,
    is_blocked TINYINT(1) DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE IF NOT EXISTS admins (
    id INT AUTO_INCREMENT PRIMARY KEY,
    tg_id BIGINT NOT NULL UNIQUE,
    role ENUM('owner','admin','staff') DEFAULT 'admin'
);

CREATE TABLE IF NOT EXISTS services (
    id INT AUTO_INCREMENT PRIMARY KEY,
    type ENUM('premium','stars','number') NOT NULL,
    title_fa VARCHAR(255) NOT NULL,
    title_en VARCHAR(255) NOT NULL,
    callino_service_code VARCHAR(64) NOT NULL,
    base_price BIGINT NOT NULL DEFAULT 0,
    profit_fixed BIGINT NOT NULL DEFAULT 0,
    profit_percent INT NOT NULL DEFAULT 0,
    active TINYINT(1) DEFAULT 1
);

CREATE TABLE IF NOT EXISTS orders (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    service_id INT NOT NULL,
    quantity INT DEFAULT 1,
    target VARCHAR(255) DEFAULT NULL,
    status ENUM('waiting_receipt','waiting_admin','paid','processing','done','canceled','failed')
        DEFAULT 'waiting_receipt',
    final_price BIGINT NOT NULL,
    callino_order_id VARCHAR(64) DEFAULT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id),
    FOREIGN KEY (service_id) REFERENCES services(id)
);

CREATE TABLE IF NOT EXISTS payments (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    order_id INT NOT NULL,
    type ENUM('card2card') DEFAULT 'card2card',
    amount BIGINT NOT NULL,
    status ENUM('pending','approved','rejected') DEFAULT 'pending',
    receipt_file_id VARCHAR(255) DEFAULT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id),
    FOREIGN KEY (order_id) REFERENCES orders(id)
);

CREATE TABLE IF NOT EXISTS states (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    state VARCHAR(64) NOT NULL,
    data TEXT,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    UNIQUE KEY uniq_user (user_id),
    FOREIGN KEY (user_id) REFERENCES users(id)
);

CREATE TABLE IF NOT EXISTS settings (
    `key` VARCHAR(64) PRIMARY KEY,
    `value` TEXT NOT NULL
);
