<?php
session_start();
require_once "helpers.php";
require_once "config.php";

// لاگین ساده
if (!isset($_SESSION['logged_in'])) {
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        if ($_POST['user'] === $PANEL_USER && $_POST['pass'] === $PANEL_PASS) {
            $_SESSION['logged_in'] = true;
            header("Location: admin.php");
            exit;
        } else {
            $error = "نام کاربری یا رمز اشتباه است.";
        }
    }
    ?>
    <html lang="fa" dir="rtl">
    <head><meta charset="UTF-8"><title>ورود پنل مدیریت</title>
    <style>
    body {font-family:tahoma;background:#f7f7f7;direction:rtl;}
    .box{width:300px;margin:80px auto;padding:20px;background:#fff;border:1px solid #ccc;}
    input{width:100%;margin:5px 0;padding:6px;}
    </style>
    </head>
    <body>
    <div class="box">
        <h3>ورود پنل مدیریت</h3>
        <?php if (!empty($error)) echo "<p style='color:red'>$error</p>"; ?>
        <form method="post">
            <input type="text" name="user" placeholder="نام کاربری">
            <input type="password" name="pass" placeholder="رمز عبور">
            <input type="submit" value="ورود">
        </form>
    </div>
    </body>
    </html>
    <?php
    exit;
}

// خروج
if (isset($_GET['logout'])) {
    session_destroy();
    header("Location: admin.php");
    exit;
}

// پردازش فرم تنظیمات
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action']==='save_settings') {
    $keys = [
        'business_info','ai_rules','ai_tone','ai_answer_length','ai_allow_offtopic',
        'limit_enabled','limit_per_day','require_phone',
        'methods_text_enabled','methods_voice_enabled',
        'report_channel_enabled','report_channel_id',
        'support_button_label','end_button_label',
        'welcome_text','support_text','limit_text','join_required_text',
        'ai_api_url','ai_api_key','ai_model'
    ];
    foreach ($keys as $k) {
        $v = isset($_POST[$k]) ? $_POST[$k] : '';
        set_setting($k, $v);
    }
    $msg_saved = "تنظیمات با موفقیت ذخیره شد.";
}

// صفحه فعال
$page = $_GET['page'] ?? 'dashboard';

// آمار ساده
$users_count = $conn->query("SELECT COUNT(*) c FROM users")->fetch_assoc()['c'] ?? 0;
$msgs_count  = $conn->query("SELECT COUNT(*) c FROM messages")->fetch_assoc()['c'] ?? 0;
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="UTF-8">
<title>پنل مدیریت ربات پشتیبانی</title>
<style>
body{font-family:tahoma;background:#f5f5f5;margin:0;direction:rtl;}
header{background:#222;color:#fff;padding:10px 20px;}
nav a{color:#fff;margin:0 10px;text-decoration:none;}
nav a.active{text-decoration:underline;}
.container{padding:20px;}
textarea{width:100%;min-height:80px;}
input[type=text],input[type=number],input[type=password]{width:100%;padding:5px;margin:3px 0;}
table{width:100%;border-collapse:collapse;background:#fff;}
th,td{border:1px solid #ccc;padding:5px;font-size:12px;vertical-align:top;}
th{background:#eee;}
.label{display:inline-block;padding:2px 6px;border-radius:4px;font-size:11px;}
.badge{background:#007bff;color:#fff;border-radius:10px;padding:2px 6px;font-size:11px;}
</style>
</head>
<body>
<header>
    <span>پنل مدیریت ربات پشتیبانی با هوش مصنوعی (نسخه بازنویسی شده)</span>
    <nav style="float:left">
        <a href="admin.php?page=dashboard" class="<?= $page=='dashboard'?'active':'' ?>">داشبورد</a>
        <a href="admin.php?page=settings"  class="<?= $page=='settings'?'active':'' ?>">تنظیمات ربات</a>
        <a href="admin.php?page=messages"  class="<?= $page=='messages'?'active':'' ?>">پیام‌ها</a>
        <a href="admin.php?page=users"     class="<?= $page=='users'?'active':'' ?>">کاربران</a>
        <a href="admin.php?page=admins"    class="<?= $page=='admins'?'active':'' ?>">ادمین‌های تلگرام</a>
        <a href="admin.php?logout=1">خروج</a>
    </nav>
    <div style="clear:both"></div>
</header>
<div class="container">
<?php if (!empty($msg_saved)) echo "<p style='color:green'>$msg_saved</p>"; ?>

<?php if ($page=='dashboard'): ?>

    <h3>آمار کلی</h3>
    <p>تعداد کاربران: <span class="badge"><?= $users_count ?></span></p>
    <p>تعداد پیام‌ها: <span class="badge"><?= $msgs_count ?></span></p>
    <p>برای تنظیم دقیق قوانین پاسخگویی، لحن رسمی/عامیانه، محدودیت پیام، جوین اجباری و ... به تب «تنظیمات ربات» بروید.</p>

<?php elseif ($page=='settings'): ?>

    <?php
    // خواندن تنظیمات
    $vals = [];
    $keys = [
        'business_info','ai_rules','ai_tone','ai_answer_length','ai_allow_offtopic',
        'limit_enabled','limit_per_day','require_phone',
        'methods_text_enabled','methods_voice_enabled',
        'report_channel_enabled','report_channel_id',
        'support_button_label','end_button_label',
        'welcome_text','support_text','limit_text','join_required_text',
        'ai_api_url','ai_api_key','ai_model'
    ];
    foreach ($keys as $k) $vals[$k] = get_setting($k,'');
    ?>
    <h3>تنظیمات ربات و هوش مصنوعی</h3>
    <form method="post">
        <input type="hidden" name="action" value="save_settings">

        <h4>اطلاعات کلی کسب‌وکار</h4>
        <textarea name="business_info"><?= htmlspecialchars($vals['business_info']) ?></textarea>

        <h4>قوانین پاسخگویی</h4>
        <textarea name="ai_rules"><?= htmlspecialchars($vals['ai_rules']) ?></textarea>

        <h4>لحن و طول پاسخ</h4>
        <label>لحن:
            <select name="ai_tone">
                <option value="formal"  <?= $vals['ai_tone']=='formal'?'selected':'' ?>>رسمی</option>
                <option value="casual"  <?= $vals['ai_tone']=='casual'?'selected':'' ?>>عامیانه</option>
            </select>
        </label><br>
        <label>طول پاسخ:
            <select name="ai_answer_length">
                <option value="short" <?= $vals['ai_answer_length']=='short'?'selected':'' ?>>کوتاه</option>
                <option value="long"  <?= $vals['ai_answer_length']=='long'?'selected':'' ?>>بلند</option>
            </select>
        </label><br>
        <label>
            اجازه پاسخ به سوالات متفرقه؟
            <select name="ai_allow_offtopic">
                <option value="0" <?= $vals['ai_allow_offtopic']=='0'?'selected':'' ?>>خیر</option>
                <option value="1" <?= $vals['ai_allow_offtopic']=='1'?'selected':'' ?>>بله</option>
            </select>
        </label>

        <h4>محدودیت پیام‌های روزانه</h4>
        <label>فعال؟
            <select name="limit_enabled">
                <option value="0" <?= $vals['limit_enabled']=='0'?'selected':'' ?>>خیر</option>
                <option value="1" <?= $vals['limit_enabled']=='1'?'selected':'' ?>>بله</option>
            </select>
        </label>
        <label>تعداد پیام مجاز در روز:
            <input type="number" name="limit_per_day" value="<?= htmlspecialchars($vals['limit_per_day']) ?>">
        </label>
        <textarea name="limit_text"><?= htmlspecialchars($vals['limit_text']) ?></textarea>

        <h4>روش‌های ارسال</h4>
        <label>ارسال متنی:
            <select name="methods_text_enabled">
                <option value="1" <?= $vals['methods_text_enabled']=='1'?'selected':'' ?>>فعال</option>
                <option value="0" <?= $vals['methods_text_enabled']=='0'?'selected':'' ?>>غیرفعال</option>
            </select>
        </label>
        <label>ارسال وویس:
            <select name="methods_voice_enabled">
                <option value="0" <?= $vals['methods_voice_enabled']=='0'?'selected':'' ?>>فعلا غیرفعال (نیاز به STT)</option>
                <option value="1" <?= $vals['methods_voice_enabled']=='1'?'selected':'' ?>>فعال</option>
            </select>
        </label>

        <h4>کانال گزارشات</h4>
        <label>فعال؟
            <select name="report_channel_enabled">
                <option value="0" <?= $vals['report_channel_enabled']=='0'?'selected':'' ?>>خیر</option>
                <option value="1" <?= $vals['report_channel_enabled']=='1'?'selected':'' ?>>بله</option>
            </select>
        </label>
        <label>آیدی عددی کانال:
            <input type="text" name="report_channel_id" value="<?= htmlspecialchars($vals['report_channel_id']) ?>">
        </label>

        <h4>متن‌ها و دکمه‌های ربات</h4>
        <label>متن خوشامد:</label>
        <textarea name="welcome_text"><?= htmlspecialchars($vals['welcome_text']) ?></textarea>

        <label>متن توضیح پشتیبانی:</label>
        <textarea name="support_text"><?= htmlspecialchars($vals['support_text']) ?></textarea>

        <label>نام دکمه پشتیبانی:</label>
        <input type="text" name="support_button_label" value="<?= htmlspecialchars($vals['support_button_label']) ?>">

        <label>نام دکمه پایان مکالمه:</label>
        <input type="text" name="end_button_label" value="<?= htmlspecialchars($vals['end_button_label']) ?>">

        <h4>تنظیمات اتصال به وب سرویس AI</h4>
        <label>API URL:
            <input type="text" name="ai_api_url" value="<?= htmlspecialchars($vals['ai_api_url']) ?>">
        </label>
        <label>API Key:
            <input type="text" name="ai_api_key" value="<?= htmlspecialchars($vals['ai_api_key']) ?>">
        </label>
        <label>Model:
            <input type="text" name="ai_model" value="<?= htmlspecialchars($vals['ai_model']) ?>">
        </label>

        <br><br>
        <input type="submit" value="ذخیره تنظیمات">
    </form>

<?php elseif ($page=='messages'): ?>

    <h3>لیست پیام‌ها</h3>
    <?php
    $res = $conn->query("SELECT m.*, u.tg_id, u.username FROM messages m
                         LEFT JOIN users u ON m.user_id = u.id
                         ORDER BY m.id DESC LIMIT 200");
    ?>
    <table>
        <tr>
            <th>#</th><th>کاربر</th><th>نقش</th><th>نوع</th><th>متن</th><th>زمان</th>
        </tr>
        <?php while($row = $res->fetch_assoc()): ?>
        <tr>
            <td><?= $row['id'] ?></td>
            <td>
                ID: <?= $row['tg_id'] ?><br>
                @<?= htmlspecialchars($row['username']) ?>
            </td>
            <td><?= $row['role'] ?></td>
            <td><?= $row['msg_type'] ?></td>
            <td><?= nl2br(htmlspecialchars($row['content'])) ?></td>
            <td><?= $row['created_at'] ?></td>
        </tr>
        <?php endwhile; ?>
    </table>

<?php elseif ($page=='users'): ?>

    <h3>کاربران</h3>
    <?php
    $res = $conn->query("SELECT * FROM users ORDER BY id DESC LIMIT 200");
    ?>
    <table>
        <tr>
            <th>#</th><th>آیدی</th><th>یوزرنیم</th><th>تلفن</th><th>ثبت‌نام</th><th>آخرین فعالیت</th><th>پیام امروز</th></tr>
        <?php while($u = $res->fetch_assoc()): ?>
        <tr>
            <td><?= $u['id'] ?></td>
            <td><?= $u['tg_id'] ?></td>
            <td>@<?= htmlspecialchars($u['username']) ?></td>
            <td><?= htmlspecialchars($u['phone']) ?></td>
            <td><?= $u['created_at'] ?></td>
            <td><?= $u['last_seen'] ?></td>
            <td><?= $u['daily_count'] ?></td>
        </tr>
        <?php endwhile; ?>
    </table>

<?php elseif ($page=='admins'): ?>

    <h3>ادمین‌های تلگرام</h3>
    <?php
    if ($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['add_admin'])) {
        $id = (int)$_POST['tg_id'];
        $un = $_POST['username'];
        $stmt = $conn->prepare("INSERT INTO admins (tg_id, username) VALUES (?, ?) ON DUPLICATE KEY UPDATE username=VALUES(username)");
        $stmt->bind_param("is", $id, $un);
        $stmt->execute();
        echo "<p style='color:green'>ادمین ذخیره شد.</p>";
    }
    if (isset($_GET['del'])) {
        $id=(int)$_GET['del'];
        $conn->query("DELETE FROM admins WHERE id = $id");
        echo "<p style='color:green'>ادمین حذف شد.</p>";
    }
    $res = $conn->query("SELECT * FROM admins ORDER BY id DESC");
    ?>
    <form method="post">
        <input type="hidden" name="add_admin" value="1">
        <label>آیدی عددی تلگرام ادمین:</label>
        <input type="text" name="tg_id">
        <label>یوزرنیم (اختیاری):</label>
        <input type="text" name="username">
        <input type="submit" value="افزودن / به‌روزرسانی ادمین">
    </form>
    <br>
    <table>
        <tr><th>#</th><th>tg_id</th><th>username</th><th>عملیات</th></tr>
        <?php while($a = $res->fetch_assoc()): ?>
        <tr>
            <td><?= $a['id'] ?></td>
            <td><?= $a['tg_id'] ?></td>
            <td>@<?= htmlspecialchars($a['username']) ?></td>
            <td><a href="admin.php?page=admins&del=<?= $a['id'] ?>" onclick="return confirm('حذف شود؟')">حذف</a></td>
        </tr>
        <?php endwhile; ?>
    </table>

<?php endif; ?>

</div>
</body>
</html>
