<?php
require_once "helpers.php";
require_once "config.php";

function ai_reply($user_message, $user_id = null) {

    global $conn;

    // دریافت 10 پیام آخر کاربر (user & bot)
    $history = [];
    if ($user_id) {
        $stmt = $conn->prepare("
            SELECT role, content 
            FROM messages 
            WHERE user_id = ? 
            ORDER BY id DESC 
            LIMIT 10
        ");
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        $res = $stmt->get_result();
        while ($row = $res->fetch_assoc()) {
            $history[] = [
                "role" => $row['role'] === "user" ? "user" : "assistant",
                "content" => $row['content']
            ];
        }
        $stmt->close();
    }

    // معکوس کردن ترتیب (قدیمی → جدید)
    $history = array_reverse($history);

    // تنظیمات AI
    $business_info = get_setting('business_info', '');
    $ai_rules      = get_setting('ai_rules', '');
    $tone          = get_setting('ai_tone', 'formal');
    $length        = get_setting('ai_answer_length', 'short');
    $allow_off     = get_setting('ai_allow_offtopic', '0');

    $tone_text = ($tone === 'formal') ? 'لحن رسمی و مودبانه' : 'لحن دوستانه و خودمانی';
    $len_text  = ($length === 'short') ? 'پاسخ‌ها کوتاه باشند' : 'پاسخ‌ها می‌توانند کمی طولانی باشند';
    $offtopic  = ($allow_off === '1')
        ? 'اگر سؤال متفرقه بود هم تا حد امکان کمک کن.'
        : 'اگر سؤال مرتبط نبود، محترمانه بگو جزو خدمات ما نیست و بحث را به خدمات برگردان.';

    // پیام راهنما (سیستم)
    $system_prompt = "
شما یک ربات پشتیبانی فارسی هستید.
توضیحات کسب‌وکار:
$business_info

قوانین پاسخگویی:
$ai_rules
$tone_text
$len_text
$offtopic

هیچ‌وقت مکالمه را با سلام، خوشامد یا مقدمه تکراری شروع نکن.
فقط جواب مرتبط بده.
    ";

    // ساختار نهایی پیام‌ها برای AI
    $messages = [
        ["role" => "system", "content" => $system_prompt]
    ];

    // اضافه کردن تاریخچه واقعی گفتگو
    foreach ($history as $h)
        $messages[] = $h;

    // پیام جدید کاربر
    $messages[] = [
        "role" => "user",
        "content" => $user_message
    ];

    // آدرس API
    $api_url = get_setting('ai_api_url', $DEFAULT_AI_API_URL);
    $api_key = get_setting('ai_api_key', $DEFAULT_AI_API_KEY);
    $model   = get_setting('ai_model',   $DEFAULT_AI_MODEL);

    // اگر تنظیم نشده باشد
    if (!$api_url || !$api_key || !$model) {
        return "سیستم هوش مصنوعی هنوز تنظیم نشده است 🌸";
    }

    // درخواست
    $payload = [
        "model" => $model,
        "messages" => $messages,
        "temperature" => 0.7
    ];

    $ch = curl_init($api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Content-Type: application/json",
        "Authorization: Bearer " . $api_key
    ]);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload, JSON_UNESCAPED_UNICODE));

    $res = curl_exec($ch);
    $err = curl_error($ch);
    curl_close($ch);

    if ($err || !$res) {
        return "خطا در ارتباط با هوش مصنوعی رخ داد 🙏";
    }

    $data = json_decode($res, true);

    if (isset($data["choices"][0]["message"]["content"])) {
        return $data["choices"][0]["message"]["content"];
    }

    return "پاسخ قابل دریافت نبود.";
}
