CREATE TABLE IF NOT EXISTS settings (
    `key`   VARCHAR(100) PRIMARY KEY,
    `value` TEXT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS admins (
    id INT AUTO_INCREMENT PRIMARY KEY,
    tg_id BIGINT UNIQUE,
    username VARCHAR(255),
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    tg_id BIGINT UNIQUE,
    username VARCHAR(255),
    phone VARCHAR(50),
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
    last_seen DATETIME,
    daily_count INT DEFAULT 0,
    last_message_date DATE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS messages (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT,
    role ENUM('user','bot','admin') DEFAULT 'user',
    msg_type ENUM('text','voice') DEFAULT 'text',
    content LONGTEXT,
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS join_targets (
    id INT AUTO_INCREMENT PRIMARY KEY,
    target_type ENUM('channel','group') DEFAULT 'channel',
    title VARCHAR(255),
    invite_link VARCHAR(255),
    is_active TINYINT(1) DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- مقداردهی اولیه تنظیمات شبیه امکانات فکت‌وب
INSERT INTO settings (`key`,`value`) VALUES
('business_info', ''),
('ai_rules', 'پاسخ‌ها کوتاه، مودب و کاربردی باشند. فقط به زبان فارسی پاسخ بده.'),
('ai_tone', 'formal'),              -- formal | casual
('ai_answer_length', 'short'),      -- short | long
('ai_allow_offtopic', '0'),         -- 0 یا 1
('limit_enabled', '0'),
('limit_per_day', '10'),
('require_phone', '0'),
('methods_text_enabled', '1'),
('methods_voice_enabled', '0'),
('report_channel_enabled', '0'),
('report_channel_id', ''),
('support_button_label', '🧑‍💻 ارتباط با پشتیبانی'),
('end_button_label', '❌ پایان مکالمه'),
('welcome_text', 'سلام 👋 به ربات پشتیبانی خوش آمدید. برای شروع روی دکمه پشتیبانی بزنید.'),
('support_text', 'سؤال خود را در مورد خدمات/محصولات ما بپرسید 🌸'),
('limit_text', 'شما به سقف تعداد پیام مجاز امروز رسیده‌اید. لطفاً فردا دوباره تلاش کنید.'),
('join_required_text', 'برای استفاده از پشتیبانی، ابتدا در کانال‌های زیر عضو شوید و سپس /start را دوباره ارسال کنید.'),
('ai_api_url', ''),
('ai_api_key', ''),
('ai_model', 'gpt-4.1-mini');
