<?php
require_once "db.php";
require_once "config.php";

// خواندن تنظیمات از جدول
function get_setting($key, $default = '') {
    global $conn;
    $stmt = $conn->prepare("SELECT value FROM settings WHERE `key` = ? LIMIT 1");
    $stmt->bind_param("s", $key);
    $stmt->execute();
    $stmt->bind_result($val);
    if ($stmt->fetch()) {
        $stmt->close();
        return $val;
    }
    $stmt->close();
    return $default;
}

function set_setting($key, $value) {
    global $conn;
    $stmt = $conn->prepare("INSERT INTO settings (`key`,`value`) VALUES (?,?)
                            ON DUPLICATE KEY UPDATE `value` = VALUES(`value`)");
    $stmt->bind_param("ss", $key, $value);
    return $stmt->execute();
}

// ارسال پیام ساده به تلگرام
function tg_send($chat_id, $text, $reply_markup = null) {
    global $BOT_TOKEN;

    $url = "https://api.telegram.org/bot$BOT_TOKEN/sendMessage";
    $params = [
        "chat_id" => $chat_id,
        "text"    => $text,
        "parse_mode" => "HTML"
    ];
    if ($reply_markup) {
        $params["reply_markup"] = json_encode($reply_markup);
    }

    file_get_contents($url . "?" . http_build_query($params));
}

// کیبورد اصلی شبیه فکت‌وب (دکمه پشتیبانی و پایان مکالمه)
function main_menu_keyboard() {
    $support_btn = get_setting('support_button_label', '🧑‍💻 ارتباط با پشتیبانی');
    $end_btn     = get_setting('end_button_label', '❌ پایان مکالمه');

    return [
        "keyboard" => [
            [ ["text" => $support_btn] ],
            [ ["text" => $end_btn] ]
        ],
        "resize_keyboard" => true,
        "one_time_keyboard" => false
    ];
}

// پیدا/ایجاد کاربر
function find_or_create_user($tg_id, $username) {
    global $conn;
    $stmt = $conn->prepare("SELECT id FROM users WHERE tg_id = ? LIMIT 1");
    $stmt->bind_param("i", $tg_id);
    $stmt->execute();
    $stmt->bind_result($id);
    if ($stmt->fetch()) {
        $stmt->close();
        $conn->query("UPDATE users SET username = '".$conn->real_escape_string($username)."', last_seen = NOW() WHERE id = $id");
        return $id;
    }
    $stmt->close();

    $stmt = $conn->prepare("INSERT INTO users (tg_id, username, created_at, last_seen) VALUES (?, ?, NOW(), NOW())");
    $stmt->bind_param("is", $tg_id, $username);
    $stmt->execute();
    return $stmt->insert_id;
}

// بررسی محدودیت پیام روزانه
function check_daily_limit($user_id) {
    global $conn;
    $limit_enabled = get_setting('limit_enabled', '0');
    if ($limit_enabled != '1') return true;

    $limit_per_day = (int)get_setting('limit_per_day', '10');
    $today = date('Y-m-d');

    $stmt = $conn->prepare("SELECT daily_count, last_message_date FROM users WHERE id = ? LIMIT 1");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $stmt->bind_result($daily_count, $last_date);
    if ($stmt->fetch()) {
        $stmt->close();
        if ($last_date !== $today) {
            $conn->query("UPDATE users SET daily_count = 0, last_message_date = '$today' WHERE id = $user_id");
            return true;
        }
        if ($daily_count >= $limit_per_day) {
            return false;
        }
        return true;
    }
    $stmt->close();
    return true;
}

function increment_daily_count($user_id) {
    global $conn;
    $today = date('Y-m-d');
    $conn->query("UPDATE users SET daily_count = daily_count + 1, last_message_date = '$today' WHERE id = $user_id");
}

// ذخیره پیام در دیتابیس
function save_message($user_id, $role, $type, $content) {
    global $conn;
    $stmt = $conn->prepare("INSERT INTO messages (user_id, role, msg_type, content) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("isss", $user_id, $role, $type, $content);
    $stmt->execute();
}

// آیا این کاربر ادمین است؟
function is_tg_admin($tg_id) {
    global $conn, $MAIN_ADMIN_ID;
    if ($tg_id == $MAIN_ADMIN_ID) return true;
    $stmt = $conn->prepare("SELECT id FROM admins WHERE tg_id = ? LIMIT 1");
    $stmt->bind_param("i", $tg_id);
    $stmt->execute();
    $stmt->bind_result($id);
    if ($stmt->fetch()) {
        $stmt->close();
        return true;
    }
    $stmt->close();
    return false;
}
